#!/usr/bin/perl

#---------------------------------------------------------------------------
# uShop Online Shopping System
# Copyright (c) 1997 - 2001; Microburst Technologies, Inc.
# All rights reserved.
#
# ushop_order_reader.pl
$version = "3.40";
#
#
# DESCRIPTION:
#
# This is a special version of the ushop.pl script that is designed to
# only allow access to uShop's Order Reader Utility.  It can be useful for
# storeowners who would like to allow someone to check/read orders ... but
# not allow them to change any of the other store settings.
#
#
# INSTALLATION INSTRUCTIONS:
#
# Configure the 13 configuration questions below as you did with your
# regular version of the ushop.pl script.  Be sure to use the EXACT SAME 
# VALUES for all of the 13 questions EXEPT:
#
# - Configuration question #4 should have the URL of this "ushop_order_reader.pl"
# script instead of the "ushop.pl" script.
#
# - Configuration question #13 should have a different password that what
# you are using with your "ushop.pl" script.
#
# Note: After configuring the 13 questions in this script, you should put this
# script on your server IN THE SAME DIRECTORY AS YOUR "ushop.pl" SCRIPT.
#
#
# USING THIS SCRIPT:
#
# To use this script to read orders, simply go to the new URL that you 
# configured in question #4 and use the new password that you configured in
# question #13 to login.
#
#---------------------------------------------------------------------------

#---------------------------------------------------------------------------
# Start Of Configuration Questions
#---------------------------------------------------------------------------

# 1. What is the path to Perl?
# This value is specified on the very first line of this file.

# 2. What is your uShop License Number?
$license_number = "ORDER READER";

# 3. What is the URL of your website?
$store_url = "http://www.yourdomain.com/";

# 4. What is the secure URL of this script?
$secure_script_url = "https://www.yourdomain.com/cgi-bin/ushop_order_reader.pl";

# 5. What is the full or relative path to your data directory?
$data_directory = "./data/";

# 6. What is the name of the settings file?
$settings_file = $data_directory . "ushop-settings.txt";  # DO NOT MODIFY

# 7. What email method do you want to use?  (SENDMAIL, BLAT or SOCKETS)
$email_method  = "SENDMAIL";  # This must be set to "BLAT" or "SOCKETS" for NT servers.

# 8. If using SENDMAIL in question #7 above, what is the path to sendmail?
$sendmail_path = "/usr/lib/sendmail";

# 9. If using BLAT in question #7 above, what is the path to Blat?
$blat_path = "C:/Blat/blat.exe";

# 10. If using SOCKETS in question #7 above, what is the IP address (or name) of you mail server?
$smtp_address = "000.000.000.0";

# 11. What is the name of the uShop language file?
require "ushop-languages.pl"; # DO NOT MODIFY

# 12. What is the name of the uShop library file?
require "ushop-lib.pl"; # DO NOT MODIFY

# 13. What password would you like to use to login?
$login_password = "mypassword";

#---------------------------------------------------------------------------
# End Of Configuration Questions
#---------------------------------------------------------------------------

#END#

#---------------------------------------------------------------------------
#
# START OF SCRIPT MAIN.
#
#
#---------------------------------------------------------------------------

# Begin by parsing the parameters.
&parse_form_data(*form_text);

$command = $form_text{'command'};
$password = $form_text{'password'};
$gfile = $form_text{'file'};
$confirm = $form_text{'confirm'};

# Get general settings.
&default_settings();
&initialize_settings();

# Decipher command and perform corresponding action.
if ($command eq "login")
{
   # Create the order reader form.
   &create_order_reader_form("NONE");
}
elsif ($command eq "cp_order_reader")
{
   # Create the order reader form.
   &create_order_reader_form("NONE");
}
elsif ($command eq $lang_read_order)
{
   # Display the order file.
   &display_order_file($gfile);
}	
elsif ($command eq $lang_read_all)
{
   # Display all order files.
   &display_all_order_files();
}	
elsif ($command eq $lang_delete_order)
{
   # Delete the order file.
   if ($gfile ne "NONE")
   {
      # Confirm the deletion
      &create_delete_file_confirmation_form($gfile,"confirm_deletion");
   }
   else
   {
      &create_order_reader_form($lang_no_order_files);
   }
}
elsif ($command eq "confirm_deletion")
{
   # Delete the order file and display order reader form.
   if ($confirm eq "$lang_yes")
   {
      unlink($data_directory . $gfile);
      &create_order_reader_form($lang_file_deleted);
   }
   else
   {
      &create_order_reader_form($lang_file_not_deleted);
   }
}	
elsif ($command eq $lang_back)
{
   # Create the main form.
   &create_order_reader_form("You have Order Reader permission only.");
}
else
{
   # Otherwise, create the login form.
   &create_login_form();
}

#---------------------------------------------------------------------------
# End of script main.
#---------------------------------------------------------------------------

#---------------------------------------------------------------------------
#
# START OF SUBROUTINES.
#
#
#---------------------------------------------------------------------------


#---------------------------------------------------------------------------
# The custom payment option has been disabled in this version of the script.
#---------------------------------------------------------------------------
sub get_custom_payment_button_html
{
   local ($payment_button_label, $payment_button_instructions) = @_;
   local ($button_html);
   $button_html = "";

   return $button_html;
}
# End of get_custom_payment_button_html()


#---------------------------------------------------------------------------
# The complete order option has been disabled in this version of the script.
#---------------------------------------------------------------------------
sub complete_order
{
   local ($order_form_html,
          $order_action,
          $order_instructions,
          $order_footer,
          $receipt_text,
          $an_response_code,
          $an_response_reason_text,
          $an_auth_code,
          $an_avs_code,
          $lp_response_code,
          $lp_status,
          $temp_file,
          $cod_modifier,
          $cod_tax_rate);
       
   exit;
}
# End of complete_order()


#---------------------------------------------------------------------------
# Subroutine to read the order file.
#---------------------------------------------------------------------------
sub read_order_file
{
   local ($order_file) = @_;  
   local ($idx,@lines);

   $order_file = &validate_filename($order_file);

   # Check if file exists.
   if (!(-e $data_directory . $order_file))
   {
      &return_error("File Error","Unable to locate " . $order_file);
   }
   
   # First open general settings file for reading.
   if (open (ORDER_FILE, $data_directory . $order_file))
   {
      # Read the entire order file.
      @lines = <ORDER_FILE>;
   
      # Close the order file.
      close(ORDER_FILE);

      # Loop through and remove carriage return from each line.
      for ($idx = 0; $idx <= $#lines; $idx++)
      {
         # Remove the carriage return.
         chop($lines[$idx]);
      }

      # Map to global variables.
      $billing_first_name = $lines[0];
      $billing_last_name = $lines[1];
      $billing_company = $lines[2];
      $billing_customer_id = $lines[3];
      $billing_street1 = $lines[4];
      $billing_street2 = $lines[5];
      $billing_city = $lines[6];
      $billing_state = $lines[7];
      $billing_zip_code = $lines[8];
      $billing_country = $lines[9];
      $billing_phone = $lines[10];
      $billing_fax = $lines[11];
      $billing_email = $lines[12];
      $billing_url = $lines[13];
      $billing_extra1 = $lines[14];
      $billing_extra2 = $lines[15];
      $billing_extra3 = $lines[16];
      $billing_extra4 = $lines[17];
      $billing_extra5 = $lines[18];
      $shipping_first_name = $lines[19];
      $shipping_last_name = $lines[20];
      $shipping_company = $lines[21];
      $shipping_customer_id = $lines[22];
      $shipping_street1 = $lines[23];
      $shipping_street2 = $lines[24];
      $shipping_city = $lines[25];
      $shipping_state = $lines[26];
      $shipping_zip_code = $lines[27];
      $shipping_country = $lines[28];
      $shipping_phone = $lines[29];
      $shipping_fax = $lines[30];
      $shipping_email = $lines[31];
      $shipping_url = $lines[32];
      $shipping_extra1 = $lines[33];
      $shipping_extra2 = $lines[34];
      $shipping_extra3 = $lines[35];
      $shipping_extra4 = $lines[36];
      $shipping_extra5 = $lines[37];
      $shipping_method = $lines[38];
      $payment_method = $lines[39];
      $tax_rate = $lines[40];
      $comments = $lines[41];
      $extra_field1 = $lines[42];
      $extra_field2 = $lines[43];
      $extra_field3 = $lines[44];
      $extra_field4 = $lines[45];
      $extra_field5 = $lines[46];
      $cc_type = $lines[47];
      $cc_name_on_card = $lines[48];
      $cc_number = $lines[49];
      $cc_expiration = $lines[50];
      $cc_issue = $lines[51];
      $echeck_bank_name = $lines[52];
      $echeck_bank_address = $lines[53];
      $echeck_name_on_check = $lines[54];
      $echeck_check_number = $lines[55];
      $echeck_account_number = $lines[56];
      $echeck_routing_number = $lines[57];
      $echeck_transit_code = $lines[58];
      $order_number = $lines[59];
      $order_date = $lines[60];
      $order_processing_codes = $lines[61];
      $tax_shipping = $lines[62];
      $tax_based_on_shipto = $lines[63];
      $totals_tax = $lines[64];
      $totals_shipping = $lines[65];
      $totals_handling = $lines[66];
      $totals_shipping_and_handling = $lines[67];
      $totals_tax_with_shipping = $lines[68];
      $totals_total = $lines[69];
      $totals_total_with_shipping_tax = $lines[70];
      $totals_euro_total = $lines[71];
      $totals_euro_total_wst = $lines[72];
      $id = $lines[73];
      $custom_extra1 = $lines[74];
      $custom_extra2 = $lines[75];
      $custom_extra3 = $lines[76];
      $custom_extra4 = $lines[77];
      $custom_extra5 = $lines[78];
      $hidden_extra1 = $lines[79];
      $hidden_extra2 = $lines[80];
      $hidden_extra3 = $lines[81];
      $hidden_extra4 = $lines[82];
      $hidden_extra5 = $lines[83];
      $coupon_number = $lines[84];
      $discount_fee = $lines[85];
      $discount_rate = $lines[86];
      $currency_symbol = $lines[87];
      $cart_title_color = $lines[88];
      $cart_font = $lines[89];
      $cart_font_color = $lines[90];
      $cart_background_color = $lines[91];
      $cart_id_label = $lines[92];
      $cart_name_label = $lines[93];
      $cart_description_label = $lines[94];
      $cart_weight_label = $lines[95];
      $cart_quantity_label = $lines[96];
      $cart_price_label = $lines[97];
      $cart_subtotal1_label = $lines[98];
      $cart_discount_label = $lines[99];
      $cart_subtotal2_label = $lines[100];
      $cart_euro_subtotal_label = $lines[101];
      $cart_tax_label = $lines[102];
      $cart_shipping_label = $lines[103];
      $cart_handling_label = $lines[104];
      $cart_sh_label = $lines[105];
      $cart_total_label = $lines[106];
      $cart_euro_total_label = $lines[107];
      $cart_tax_label = $lines[108];
      $cart_show_id = $lines[109];
      $cart_show_name = $lines[110];
      $cart_show_description = $lines[111];
      $cart_show_weight = $lines[112];
      $cart_show_quantity = $lines[113];
      $cart_show_price = $lines[114];
      $cart_show_totals = $lines[115];
      $show_euro = $lines[116];
      $euro_symbol = $lines[117];
      $euro_rate = $lines[118];
      $totals_euro_subtotal = $lines[119];
      $totals_subtotal1 = $lines[120];
      $totals_total_discount = $lines[121];
      $totals_taxable_subtotal = $lines[122];
      $totals_nontaxable_subtotal = $lines[123];
      $totals_subtotal2 = $lines[124];
      $totals_total_quantity = $lines[125];
      $totals_total_weight = $lines[126];
      $totals_shipping_modifier = $lines[127];
      $extra_flags = $lines[128];
      $cart_product_lines = $lines[129];
      $cart_data = $lines[130];
      # Lines 131, 132, 133, and 134 are not used at this time.
      $cart_title_font_color = $lines[135];
      $REMOTE_ADDR = $lines[136];
   }
   else
   {
      # Indicate that the file was not opened.
      &return_error("File Error","Unable to open " . $order_file);
   }

   # Extra check due to new parameter.
   if (!($cart_title_font_color =~ /\S/))
   {
      $cart_title_font_color = $cart_font_color;	
   }      
}
# End of read_order_file()


#---------------------------------------------------------------------------
# The update log option has been disabled in this version of the script.
#---------------------------------------------------------------------------
sub update_customer_log
{

}
# End of update_customer_log()


#---------------------------------------------------------------------------
# The update log option has been disabled in this version of the script.
#---------------------------------------------------------------------------
sub update_inventory_log
{

}
# End of update_inventory_log()


#---------------------------------------------------------------------------
# The custom email option has been disabled in this version of the script.
#---------------------------------------------------------------------------
sub custom_email_method
{
   local ($from_address,$to_address,$subject,$message) = @_;
}
# End of custom_email_method()


#---------------------------------------------------------------------------
# The custom tax option has been disabled in this version of the script.
#---------------------------------------------------------------------------
sub custom_tax_rate
{
   return 0.0;
}
# End of custom_tax_rate()


#---------------------------------------------------------------------------
# The custom shipping option has been disabled in this version of the script.
#---------------------------------------------------------------------------
sub custom_shipping
{
   local ($shipping_table) = @_;  
   
   return 0.0;
}
# End of custom_shipping()


#---------------------------------------------------------------------------
# The custom handling option has been disabled in this version of the script.
#---------------------------------------------------------------------------
sub custom_handling
{
   return 0.0;
}
# End of custom_handling()


#---------------------------------------------------------------------------
# The validate required fields has been disabled in this version of the script.
#---------------------------------------------------------------------------
sub validate_required_fields
{

}
# End of validate_required_fields()


#---------------------------------------------------------------------------
# End of subroutines.
#---------------------------------------------------------------------------

# End of ushop_order_reader.pl
